<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone1', 'phone2', 'location', 'created_by', 'updated_by');

    public function reservations()
    {
        return $this->hasMany('App\Models\Reservation', 'client_id');
    }

}